/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.impl;

import com.cisco.pt.IPV6Address;
import com.cisco.pt.impl.LTVParsingError;
import java.util.Arrays;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IPV6AddressImpl
implements IPV6Address {
    private static Log logger = LogFactory.getLog(IPV6AddressImpl.class);
    private static final int HEX_RADIX = 16;
    public static final int IPV6ADDRESS_BYTES = 16;
    byte[] bytes = new byte[16];

    public IPV6AddressImpl(byte[] newBytes) {
        this.setBytes(newBytes);
    }

    public IPV6AddressImpl(String colonHexStr) {
        try {
            int period = colonHexStr.indexOf(46);
            int colon = colonHexStr.indexOf(58);
            if (period != -1 && colon != 1) {
                String hexIpv4 = "000000000000000000000000";
                String ipv4 = "";
                ipv4 = colonHexStr.replaceAll(":", "");
                String[] octets = ipv4.split("\\.");
                if (octets.length != 4) {
                    throw new DecoderException("IPv4 Port Mapped IPv6 Address invalid format" + colonHexStr);
                }
                for (int i = 0; i < 4; ++i) {
                    Integer value = Integer.parseInt(octets[i], 10);
                    String hexdigit = Integer.toHexString(value);
                    if (hexdigit.length() == 1) {
                        hexdigit = "0" + hexdigit;
                    }
                    hexIpv4 = hexIpv4 + hexdigit;
                }
                this.setBytes(Hex.decodeHex((char[])hexIpv4.toCharArray()));
            } else {
                colonHexStr = colonHexStr.replace('.', ':');
                String[] hextets = colonHexStr.split(":");
                int totalNonZero = 4 * hextets.length;
                String zeros = "";
                int missing = 32 - totalNonZero;
                for (int j = 0; j < missing; ++j) {
                    zeros = zeros.concat("0");
                }
                for (int i = 0; i < hextets.length; ++i) {
                    if (hextets[i].length() == 0) {
                        hextets[i] = zeros;
                        continue;
                    }
                    for (int j = hextets[i].length(); j < 4; ++j) {
                        hextets[i] = "0" + hextets[i];
                    }
                }
                String wholeString = "";
                for (int i = 0; i < hextets.length; ++i) {
                    wholeString = wholeString + hextets[i];
                }
                this.setBytes(Hex.decodeHex((char[])wholeString.toCharArray()));
            }
        }
        catch (PatternSyntaxException pse) {
            logger.error((Object)pse.getMessage());
        }
        catch (DecoderException de) {
            logger.error((Object)("Error decoding colon hex string: " + de.getMessage()));
        }
    }

    protected void setBytes(byte[] newBytes) {
        Arrays.fill(this.bytes, (byte)0);
        int offset = newBytes.length >= this.bytes.length ? 0 : this.bytes.length - newBytes.length;
        int limit = Math.min(this.bytes.length, newBytes.length);
        for (int i = 0; i < limit; ++i) {
            this.bytes[offset + i] = newBytes[i];
        }
    }

    public String getColonHexString() {
        StringBuilder builder = new StringBuilder();
        char[] chars = Hex.encodeHex((byte[])this.bytes);
        for (int i = 0; i < chars.length; ++i) {
            builder.append(chars[i]);
            if (i % 4 != 3 || i >= chars.length - 1) continue;
            builder.append(':');
        }
        return builder.toString();
    }

    public String getHexString() {
        char[] chars = Hex.encodeHex((byte[])this.bytes);
        return new String(chars);
    }

    public byte[] getByteArrayValue() {
        return this.bytes;
    }

    public static IPV6Address parseIPV6Address(String s) {
        IPV6AddressImpl ipAddr = null;
        String[] octetStrings = s.split("\\:");
        if (octetStrings.length != 8) {
            throw new LTVParsingError("Invalid format for IPV6 Address: " + s);
        }
        try {
            byte[] parseBytes = new byte[16];
            for (int index = 0; index < octetStrings.length; ++index) {
                int octet = Integer.parseInt(octetStrings[index], 16);
                parseBytes[2 * index] = (byte)(octet >> 8 & 0xFF);
                parseBytes[2 * index + 1] = (byte)(octet & 0xFF);
            }
            ipAddr = new IPV6AddressImpl(parseBytes);
        }
        catch (NumberFormatException nfe) {
            throw new LTVParsingError("Invalid format for IPV6 Address: " + s);
        }
        return ipAddr;
    }
}

